; ====================================================================================================
;
; rank.asm
;
; included from game.asm
;
; ====================================================================================================
SECTION code_user

INTERNAL_RANK_CNT_VALUE:    EQU 5   ; 内部ランク上昇時間(秒)


; ====================================================================================================
; 内部ランク加算時間リセット処理
; 内部ランク加算時間をリセットする。
; ====================================================================================================
RESET_INTERNAL_RANK_CNT:
    LD A,INTERNAL_RANK_CNT_VALUE
    LD (INTERNAL_RANK_CNT_WK),A
    RET


; ====================================================================================================
; 内部ランク加算時間判定処理
; 内部ランク加算時間を判定する。
; 条件が満たされた場合は内部ランクを加算し、内部ランク加算時間をリセットする。
; ====================================================================================================
CHECK_INTERNAL_RANK_CNT:
    LD HL,INTERNAL_RANK_CNT_WK
    DEC (HL)                        ; 内部ランク加算時間をデクリメント
    RET NZ                          ; ゼロでなければ抜ける

    LD A,1
    CALL CHANGE_INTERNAL_RANK       ; 内部ランク加算
    CALL RESET_INTERNAL_RANK_CNT    ; 内部ランク加算時間をリセット
    RET


; ====================================================================================================
; 内部ランク変動処理
; 変動値に基づき内部ランクの値を変化させる
; ただし、最低値=$00、最大値=$FFとする
; IN   A : 変動値 
; ====================================================================================================
CHANGE_INTERNAL_RANK:
    LD HL,INTERNAL_RANK

    OR A
    JP M,CHANGE_INTERNAL_RANK_L1    ; マイナスならL1へ

    ADD A,(HL)                      ; A <- 内部ランク値+変動値
    LD (HL),A                       ; 内部ランクをメモリに格納
    RET NC                          ; 上限を超えていなければそのまま終了

    LD (HL),$FF                     ; $FFに固定する
    RET

CHANGE_INTERNAL_RANK_L1:
    NEG                             ; 符号反転
    LD D,A                          ; D <- 変動値
    LD A,(HL)                       ; A <- 内部ランク
    CP D                            ; 内部ランク - 変動値 < 0 かチェック
    JP C,CHANGE_INTERNAL_RANK_L2    ; < 0 なら L2 へ

    SUB D                           ; A = 内部ランク値-変動値
    LD (HL),A                       ; 内部ランクをメモリに格納
    RET NC                          ; 下限を超えていなければそのまま終了

CHANGE_INTERNAL_RANK_L2:
    LD (HL),$00                     ; $00に固定する
    RET


; ====================================================================================================
; ワークエリア
; プログラム起動時にcrtでゼロでramに設定される 
; ====================================================================================================
SECTION bss_user

; ■内部ランク
INTERNAL_RANK:
    DEFS 1

; ■内部ランク退避
INTERNAL_RANK_SV:
    DEFS 1

; ■内部ランク加算時間カウント用(単位：秒)
INTERNAL_RANK_CNT_WK:
    DEFS 1

; ■内部ランク表示フラグ
INTERNAL_RANK_DISP:
    DEFS 1
